%% Compute delays in seconds
% Delays are relative to a reference microphone.
% The reference mic is the one first reached by the incident soundwave.
% There are thus three cases:
% 1) 0<theta<90: the "rightmost" mic is the reference. Delays are computed right-to-left.
% 2) 180<theta<90: the "leftmost" mic is the reference. Delays are computed left-to-right.
% 3) theta=90: all delays are zero.

       % This is done to eliminate "negative" delays, though this may not be necessary.

%% Add directories containing support functions.
addpath('functions')

%% Inputs
d = 11.43e-3;     % Distance between microphones.
N = 24;            % Number of microphones.
f = 20e3;         % Frequency of source. Might be multiple frequencies?? Model non-ideal source???
phi = d2r(90);       % Look-direction of beam.
psi = linspace(0, pi, 1000);
c = 343;          % Velocity of sound (in air).

%% Compute delays for angles (-90,90)

angleRes = 0:180;
delays = zeros(length(angleRes),N);
for t = angleRes        % iterate over angles (set resolution)
    for n = 1:N % iterate over sensors
        if t > 90
            tau = d*cos(d2r(t))/c;
            delays(t+1,N-n+1) = -((n-1))*tau;  % Change indexing of sensors as well as direction of distance between them (ie. d).
        else
            tau = d*cos(d2r(t))/c;
            delays(t+1,n) = (n-1)*tau;
        end
    end
end

% for i = 1:N  %% Plot delays vs angles for each mic. Expect
%     plot(angleRes, delays(:,i) )
%     hold on
% end

%% Compute clock cycles for each delay
delays(delays < 1e-12) = 0; % Ignore values less than 1ps.

fc = 2e6;
delays_Tc = ceil(fc.*delays);



